/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Network
implements Runnable {
    public static final int SIGNAL_HANDSHAKE = 0;
    public static final int SIGNAL_MESSAGE = 1;
    public static final int SIGNAL_TERMINATE = 3;
    public static final int SIGNAL_HANDSHAKE_ACK = 4;
    public static final int SIGNAL_TERMINATE_ACK = 5;
    public int pos_x = 0;
    public int pos_y = 0;
    private static final UUID uuid = new UUID("102030405060708090A0B0C0D0E0F010", false);
    private static final int SERVICE_TELEPHONY = 0x400000;
    LocalDevice localDevice = null;
    DiscoveryAgent agent = null;
    StreamConnectionNotifier server;
    BTListener callback = null;
    boolean done = false;
    public String localName = "";
    Vector Users = new Vector();
    Vector pendingUsers = new Vector();
    Hashtable serviceRecordToUser = new Hashtable();
    Object lock = new Object();
    Timer timer = new Timer();

    public void init(String string, BTListener bTListener) {
        Network.log("invoke init() untuk " + string);
        try {
            this.localName = string;
            this.callback = bTListener;
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            this.agent = this.localDevice.getDiscoveryAgent();
            Util.printLocalDevice(this.localDevice);
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (BluetoothStateException bluetoothStateException) {
            bluetoothStateException.printStackTrace();
            Network.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Network.log(iOException.getClass().getName() + " " + iOException.getMessage());
        }
    }

    public void disconnect() {
        Network.log("invoke disconnect()");
        this.done = true;
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this.Users.size(); ++i) {
            User user = (User)this.Users.elementAt(i);
            user.putString(3, "end");
            user.Kirim.stop();
            user.Baca.stop();
        }
    }

    public void query() {
        try {
            Network.log("invoke query()");
            this.agent.startInquiry(10390323, (DiscoveryListener)new Listener());
        }
        catch (BluetoothStateException bluetoothStateException) {
            bluetoothStateException.printStackTrace();
            Network.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
        }
    }

    public User findUserByRemoteDevice(RemoteDevice remoteDevice) {
        for (int i = 0; i < this.Users.size(); ++i) {
            User user = (User)this.Users.elementAt(i);
            if (!user.remoteDev.equals((Object)remoteDevice)) continue;
            return user;
        }
        return null;
    }

    public User findUserByTransId(int n) {
        for (int i = 0; i < this.pendingUsers.size(); ++i) {
            User user = (User)this.pendingUsers.elementAt(i);
            if (user.transId != n) continue;
            return user;
        }
        return null;
    }

    public void sendString(String string) {
        Network.log("invoke sendString string=" + string);
        for (int i = 0; i < this.Users.size(); ++i) {
            User user = (User)this.Users.elementAt(i);
            user.putString(1, string);
        }
    }

    public void cleanupRemoteUser(User user) {
        Network.log("invoke cleanupRemoteUser()");
        user.Baca.stop();
        user.Kirim.stop();
        this.Users.removeElement(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ServiceRecord serviceRecord;
        StreamConnection streamConnection = null;
        try {
            this.server = (StreamConnectionNotifier)Connector.open((String)("btspp://localhost:" + uuid.toString() + ";name=BlueChatApp"));
            serviceRecord = this.localDevice.getRecord((Connection)this.server);
            serviceRecord.setAttributeValue(8, new DataElement(8, 255L));
            Util.printServiceRecord(serviceRecord);
            serviceRecord.setDeviceServiceClasses(0x400000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Network.log(exception.getClass().getName() + " " + exception.getMessage());
        }
        while (!this.done) {
            try {
                Network.log("local service waiting for client connection");
                GameMain.log("Wait for another player .....");
                streamConnection = this.server.acceptAndOpen();
                Network.log("local service accept a new client connection");
                serviceRecord = RemoteDevice.getRemoteDevice((Connection)streamConnection);
                User user = this.findUserByRemoteDevice((RemoteDevice)serviceRecord);
                if (user != null) {
                    Network.log("client connection end point already exist.. ignore this connection");
                    continue;
                }
                user = new User(this, (RemoteDevice)serviceRecord, streamConnection);
                Thread thread = new Thread(user.Kirim);
                thread.start();
                Thread thread2 = new Thread(user.Baca);
                thread2.start();
                this.Users.addElement(user);
                Network.log("a new active User is established. name=" + user.remoteName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Network.log(iOException.getClass().getName() + " " + iOException.getMessage());
                if (streamConnection == null) continue;
                try {
                    streamConnection.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public static void log(String string) {
        System.out.println("Network: " + string);
    }

    class DoServiceDiscovery
    extends TimerTask {
        DoServiceDiscovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (int i = 0; i < Network.this.pendingUsers.size(); ++i) {
                User user = (User)Network.this.pendingUsers.elementAt(i);
                try {
                    Network.log("search service on device " + user.remoteName);
                    user.transId = Network.this.agent.searchServices(null, new UUID[]{uuid}, user.remoteDev, (DiscoveryListener)new Listener());
                    Object object = Network.this.lock;
                    synchronized (object) {
                        try {
                            Network.this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                catch (BluetoothStateException bluetoothStateException) {
                    bluetoothStateException.printStackTrace();
                    Network.log(((Object)((Object)bluetoothStateException)).getClass().getName() + " " + bluetoothStateException.getMessage());
                }
            }
            Network.this.pendingUsers.removeAllElements();
            GameMain.log("Game start now");
        }
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            try {
                Network.log("invoke deviceDiscovered name=" + remoteDevice.getFriendlyName(false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                User user = new User(Network.this, remoteDevice, null);
                Network.this.pendingUsers.addElement(user);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Network.log(exception.getClass().getName() + " " + exception.getMessage());
            }
        }

        public void inquiryCompleted(int n) {
            Network.log("invoke inqueryCompleted");
            Network.this.timer.schedule((TimerTask)new DoServiceDiscovery(), 100L);
        }

        public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
            Network.log("invoke servicesDiscovered:" + n + "," + serviceRecordArray.length);
            try {
                for (int i = 0; i < serviceRecordArray.length; ++i) {
                    Util.printServiceRecord(serviceRecordArray[i]);
                    User user = Network.this.findUserByTransId(n);
                    Network.this.serviceRecordToUser.put(serviceRecordArray[i], user);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Network.log(exception.getClass().getName());
                Network.log(exception.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int n, int n2) {
            Network.log("invoke serviceSearchCompleted: " + n);
            if (n2 == 1) {
                Network.log("SERVICE_SEARCH_COMPLETED");
            } else if (n2 == 2) {
                Network.log("SERVICE_SEARCH_TERMINATED");
            } else if (n2 == 3) {
                Network.log("SERVICE_SEARCH_ERROR");
            } else if (n2 == 4) {
                Network.log("SERVICE_SEARCH_NO_RECORDS");
            } else if (n2 == 6) {
                Network.log("SERVICE_SEARCH_DEVICE_NOT_REACHABLE");
            }
            Object object = Network.this.serviceRecordToUser.keys();
            while (object.hasMoreElements()) {
                try {
                    ServiceRecord serviceRecord = (ServiceRecord)object.nextElement();
                    String string = serviceRecord.getConnectionURL(0, false);
                    Network.log("BlueChat service url=" + string);
                    StreamConnection streamConnection = (StreamConnection)Connector.open((String)string);
                    User user = (User)Network.this.serviceRecordToUser.get(serviceRecord);
                    if (user != null) {
                        user.con = streamConnection;
                        Thread thread = new Thread(user.Kirim);
                        thread.start();
                        Thread thread2 = new Thread(user.Baca);
                        thread2.start();
                        Network.this.Users.addElement(user);
                        Network.log(Network.this.localName + " a new active User is established. name=" + user.remoteName);
                        user.putString(0, Network.this.localName);
                        continue;
                    }
                    Network.log("cannot find pending User when a service is discovered. ignore this service...");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Network.log(exception.getClass().getName() + " " + exception.getMessage());
                }
            }
            Network.this.serviceRecordToUser.clear();
            object = Network.this.lock;
            synchronized (object) {
                Network.this.lock.notifyAll();
            }
        }
    }
}

