/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class Util {
    private Util() {
    }

    private static void log(String string) {
        System.out.println(string);
    }

    public static void printRemoteDevice(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        try {
            Util.log("Print Remote Device " + remoteDevice.getBluetoothAddress());
            Util.log("Name: " + remoteDevice.getFriendlyName(true));
            Util.log("Auth: " + remoteDevice.isAuthenticated() + " Encrypted: " + remoteDevice.isEncrypted() + " Trusted: " + remoteDevice.isTrustedDevice());
            if (deviceClass != null) {
                Util.log("MajorDevice:" + Util.majorToName(deviceClass.getMajorDeviceClass()));
                Util.log("MinorDevice:" + Util.minorToName(deviceClass.getMajorDeviceClass(), deviceClass.getMinorDeviceClass()));
                Util.log("ServiceClass:");
                String[] stringArray = Util.majorServiceToName(deviceClass.getServiceClasses());
                for (int i = 0; i < stringArray.length; ++i) {
                    Util.log("  " + stringArray[i]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printLocalDevice(LocalDevice localDevice) {
        Util.log("Print Local Device " + localDevice.getBluetoothAddress());
        Util.log("Name: " + localDevice.getFriendlyName());
        DeviceClass deviceClass = localDevice.getDeviceClass();
        if (deviceClass != null) {
            Util.log("MajorDevice:" + Util.majorToName(deviceClass.getMajorDeviceClass()));
            Util.log("MinorDevice:" + Util.minorToName(deviceClass.getMajorDeviceClass(), deviceClass.getMinorDeviceClass()));
            Util.log("ServiceClass:");
            String[] stringArray = Util.majorServiceToName(deviceClass.getServiceClasses());
            for (int i = 0; i < stringArray.length; ++i) {
                Util.log("  " + stringArray[i]);
            }
        }
    }

    public static void printServiceRecord(ServiceRecord serviceRecord) {
        int[] nArray = serviceRecord.getAttributeIDs();
        Util.log("Print Service Record (# of element: " + nArray.length + ")");
        Util.log("Print Service Record URL " + serviceRecord.getConnectionURL(0, false));
        for (int i = 0; i < nArray.length; ++i) {
            DataElement dataElement = serviceRecord.getAttributeValue(nArray[i]);
            Util.printDataElement(dataElement, nArray[i], "");
        }
    }

    public static void printDataElement(DataElement dataElement, int n, String string) {
        int n2 = dataElement.getDataType();
        if (n2 == 56 || n2 == 48) {
            Enumeration enumeration = (Enumeration)dataElement.getValue();
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + n2 + " (# of element: " + dataElement.getSize() + ")");
            while (enumeration.hasMoreElements()) {
                DataElement dataElement2 = (DataElement)enumeration.nextElement();
                Util.printDataElement(dataElement2, n, string + "  ");
            }
        } else if (n2 == 8 || n2 == 9 || n2 == 10 || n2 == 16 || n2 == 17 || n2 == 18 || n2 == 19) {
            long l = dataElement.getLong();
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + l);
        } else if (n2 == 24) {
            UUID uUID = (UUID)dataElement.getValue();
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + Util.uuidToName(uUID));
        } else if (n2 == 11 || n2 == 12 || n2 == 20) {
            byte[] byArray = (byte[])dataElement.getValue();
            String string2 = "";
            for (int i = 0; i < byArray.length; ++i) {
                string2 = string2 + Integer.toHexString(byArray[i]);
            }
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + string2);
        } else if (n2 == 32 || n2 == 64) {
            String string3 = (String)dataElement.getValue();
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + string3);
        } else if (n2 == 40) {
            boolean bl = dataElement.getBoolean();
            Util.log(string + "DataElement[" + Util.idToName(n) + "] " + String.valueOf(bl));
        } else if (n2 == 0) {
            Util.log(string + "DataElement[" + Util.idToName(n) + "] NULL");
        }
    }

    public static String idToName(int n) {
        if (n == 0) {
            return "ServiceRecordHandle";
        }
        if (n == 1) {
            return "ServiceClassIDList";
        }
        if (n == 2) {
            return "ServiceRecordState";
        }
        if (n == 3) {
            return "ServiceID";
        }
        if (n == 4) {
            return "ProtocolDescriptorList";
        }
        if (n == 5) {
            return "BrowseGroupList";
        }
        if (n == 6) {
            return "LanguageBasedAttributeIDList";
        }
        if (n == 7) {
            return "ServiceInfoTimeToLive";
        }
        if (n == 8) {
            return "ServiceAvailability";
        }
        if (n == 9) {
            return "BluetoothProfileDescriptorList";
        }
        if (n == 10) {
            return "DocumentationURL";
        }
        if (n == 11) {
            return "ClientExecutableURL";
        }
        if (n == 12) {
            return "IconURL";
        }
        if (n == 13) {
            return "AdditionalProtocol";
        }
        if (n == 256) {
            return "ServiceName";
        }
        if (n == 257) {
            return "ServiceDescription";
        }
        if (n == 258) {
            return "ProviderName";
        }
        if (n == 512) {
            return "GroupID";
        }
        if (n == 513) {
            return "ServiceDatabaseState";
        }
        if (n == 768) {
            return "ServiceVersion";
        }
        if (n == 769) {
            return "ExternalNetwork";
        }
        if (n == 770) {
            return "RemoteAudioVolumeControl";
        }
        if (n == 771) {
            return "SupportedFormatList";
        }
        if (n == 772) {
            return "FaxClass2Support";
        }
        if (n == 773) {
            return "AudioFeedbackSupport";
        }
        if (n == 774) {
            return "NetworkAddress";
        }
        if (n == 775) {
            return "WAPGateway";
        }
        if (n == 776) {
            return "HomePageURL";
        }
        if (n == 777) {
            return "WAPStackType";
        }
        if (n == 778) {
            return "SecurityDescription";
        }
        if (n == 779) {
            return "NetAccessType";
        }
        if (n == 780) {
            return "MaxNetAccessrate";
        }
        if (n == 781) {
            return "IPv4Subnet";
        }
        if (n == 782) {
            return "IPv6Subnet";
        }
        if (n == 784) {
            return "SupportedCapabalities";
        }
        if (n == 785) {
            return "SupportedFeatures";
        }
        if (n == 786) {
            return "SupportedFunctions";
        }
        if (n == 787) {
            return "TotalImagingDataCapacity";
        }
        return "UnknownAttribute(" + n + ")";
    }

    public static String uuidToName(UUID uUID) {
        if (uUID.equals((Object)new UUID(1L))) {
            return "SDP";
        }
        if (uUID.equals((Object)new UUID(3L))) {
            return "RFCOMM";
        }
        if (uUID.equals((Object)new UUID(8L))) {
            return "OBEX";
        }
        if (uUID.equals((Object)new UUID(12L))) {
            return "HTTP";
        }
        if (uUID.equals((Object)new UUID(256L))) {
            return "L2CAP";
        }
        if (uUID.equals((Object)new UUID(15L))) {
            return "BNEP";
        }
        if (uUID.equals((Object)new UUID(4096L))) {
            return "ServiceDiscoveryServerServiceClassID";
        }
        if (uUID.equals((Object)new UUID(4097L))) {
            return "BrowseGroupDescriptorCerviceClassID";
        }
        if (uUID.equals((Object)new UUID(4098L))) {
            return "PublicBrowseGroup";
        }
        if (uUID.equals((Object)new UUID(4353L))) {
            return "SerialPort";
        }
        if (uUID.equals((Object)new UUID(4354L))) {
            return "LANAccessUsingPPP";
        }
        if (uUID.equals((Object)new UUID(4355L))) {
            return "DialupNetworking";
        }
        if (uUID.equals((Object)new UUID(4356L))) {
            return "IrMCSync";
        }
        if (uUID.equals((Object)new UUID(4357L))) {
            return "OBEX ObjectPushProfile";
        }
        if (uUID.equals((Object)new UUID(4358L))) {
            return "OBEX FileTrasnferProfile";
        }
        if (uUID.equals((Object)new UUID(4359L))) {
            return "IrMCSyncCommand";
        }
        if (uUID.equals((Object)new UUID(4360L))) {
            return "Headset";
        }
        if (uUID.equals((Object)new UUID(4361L))) {
            return "CordlessTelephony";
        }
        if (uUID.equals((Object)new UUID(4362L))) {
            return "AudioSource";
        }
        if (uUID.equals((Object)new UUID(4369L))) {
            return "Fax";
        }
        if (uUID.equals((Object)new UUID(4370L))) {
            return "HeadsetAudioGateway";
        }
        if (uUID.equals((Object)new UUID(4373L))) {
            return "PersonalAreaNetworkingUser";
        }
        if (uUID.equals((Object)new UUID(4374L))) {
            return "NetworkAccessPoint";
        }
        if (uUID.equals((Object)new UUID(4375L))) {
            return "GroupNetwork";
        }
        if (uUID.equals((Object)new UUID(4382L))) {
            return "Handsfree";
        }
        if (uUID.equals((Object)new UUID(4383L))) {
            return "HandsfreeAudioGateway";
        }
        if (uUID.equals((Object)new UUID(4609L))) {
            return "GenericNetworking";
        }
        if (uUID.equals((Object)new UUID(4610L))) {
            return "GenericFileTransfer";
        }
        if (uUID.equals((Object)new UUID(4611L))) {
            return "GenericAudio";
        }
        if (uUID.equals((Object)new UUID(4612L))) {
            return "GenericTelephony";
        }
        return uUID.toString();
    }

    public static String majorToName(int n) {
        if (n == 0) {
            return "Miscellaneous";
        }
        if (n == 256) {
            return "Computer";
        }
        if (n == 512) {
            return "Phone";
        }
        if (n == 768) {
            return "LANAccessPoint";
        }
        if (n == 1024) {
            return "AudioVideo";
        }
        if (n == 1280) {
            return "Peripheral";
        }
        if (n == 1536) {
            return "Imaging";
        }
        if (n == 7936) {
            return "Uncategorized";
        }
        return "UnknownMajorDevice(" + n + ")";
    }

    public static String minorToName(int n, int n2) {
        if (n == 0) {
            return "Miscellaneous";
        }
        if (n == 256 && n2 == 0) {
            return "Uncategorized";
        }
        if (n == 256 && n2 == 4) {
            return "Workstation";
        }
        if (n == 256 && n2 == 8) {
            return "Server";
        }
        if (n == 256 && n2 == 12) {
            return "Laptop";
        }
        if (n == 256 && n2 == 16) {
            return "HandheldPcPda";
        }
        if (n == 256 && n2 == 20) {
            return "PalmPcPda";
        }
        if (n == 256 && n2 == 24) {
            return "Wearable";
        }
        if (n == 512 && n2 == 0) {
            return "Uncategorized";
        }
        if (n == 512 && n2 == 4) {
            return "Cellular";
        }
        if (n == 512 && n2 == 8) {
            return "Cordless";
        }
        if (n == 512 && n2 == 12) {
            return "SmartPhone";
        }
        if (n == 512 && n2 == 16) {
            return "Modem";
        }
        if (n == 512 && n2 == 20) {
            return "ISDN";
        }
        if (n == 768 && n2 == 0) {
            return "FullyAvailable";
        }
        if (n == 768 && n2 == 32) {
            return "1to17%Utilized";
        }
        if (n == 768 && n2 == 64) {
            return "17to33%Utilized";
        }
        if (n == 768 && n2 == 96) {
            return "33to50%Utilized";
        }
        if (n == 768 && n2 == 128) {
            return "50to67%Utilized";
        }
        if (n == 768 && n2 == 160) {
            return "67to83%Utilized";
        }
        if (n == 768 && n2 == 192) {
            return "83to100%Utilized";
        }
        if (n == 768 && n2 == 224) {
            return "NoServiceAvailable";
        }
        if (n == 1024 && n2 == 0) {
            return "Uncategorized";
        }
        if (n == 1024 && n2 == 4) {
            return "Headset";
        }
        if (n == 1024 && n2 == 8) {
            return "HandsFree";
        }
        if (n == 1024 && n2 == 12) {
            return "(Reserved)";
        }
        if (n == 1024 && n2 == 16) {
            return "Microphone";
        }
        if (n == 1024 && n2 == 20) {
            return "Loudspeaker";
        }
        if (n == 1024 && n2 == 24) {
            return "Headphones";
        }
        if (n == 1024 && n2 == 28) {
            return "PortableAudio";
        }
        if (n == 1024 && n2 == 32) {
            return "CarAudio";
        }
        if (n == 1024 && n2 == 36) {
            return "SetTopBox";
        }
        if (n == 1024 && n2 == 40) {
            return "HiFiAudioDevice";
        }
        if (n == 1024 && n2 == 44) {
            return "VCR";
        }
        if (n == 1024 && n2 == 48) {
            return "VideoCamera";
        }
        if (n == 1024 && n2 == 52) {
            return "Camcorder";
        }
        if (n == 1024 && n2 == 56) {
            return "VideoMonitor";
        }
        if (n == 1024 && n2 == 60) {
            return "VideoDisplayAndLoudspeaker";
        }
        if (n == 1024 && n2 == 64) {
            return "VideoConferencing";
        }
        if (n == 1024 && n2 == 68) {
            return "(Reserved)";
        }
        if (n == 1024 && n2 == 72) {
            return "GamingToy";
        }
        if (n == 1280 && n2 == 0) {
            return "Uncategoried";
        }
        if (n == 1280 && n2 == 4) {
            return "Joystick";
        }
        if (n == 1280 && n2 == 8) {
            return "Gamepad";
        }
        if (n == 1280 && n2 == 12) {
            return "RemoteControl";
        }
        if (n == 1280 && n2 == 16) {
            return "SensingDevice";
        }
        if (n == 1280 && n2 == 20) {
            return "DigitizerTablet";
        }
        if (n == 1280 && n2 == 24) {
            return "CardBaca";
        }
        if (n == 1280 && n2 == 64) {
            return "Keyboard";
        }
        if (n == 1280 && n2 == 128) {
            return "PointingDevice";
        }
        if (n == 1280 && n2 == 192) {
            return "KeyboardPointingDevice";
        }
        if (n == 1536 && n2 == 16) {
            return "Display";
        }
        if (n == 1536 && n2 == 32) {
            return "Camera";
        }
        if (n == 1536 && n2 == 64) {
            return "Scanner";
        }
        if (n == 1536 && n2 == 128) {
            return "Printer";
        }
        if (n == 7936) {
            return "Uncategorized(" + n2 + ")";
        }
        return "UnknownMinorDevice(" + n2 + ")";
    }

    public static String[] majorServiceToName(int n) {
        Vector<String> vector = new Vector<String>();
        if ((n & 0x2000) > 0) {
            vector.addElement("LimitedDiscoverableMode");
        }
        if ((n & 0x10000) > 0) {
            vector.addElement("Positioning");
        }
        if ((n & 0x20000) > 0) {
            vector.addElement("Networking");
        }
        if ((n & 0x40000) > 0) {
            vector.addElement("Rendering");
        }
        if ((n & 0x80000) > 0) {
            vector.addElement("Capturing");
        }
        if ((n & 0x100000) > 0) {
            vector.addElement("ObjectTransfer");
        }
        if ((n & 0x200000) > 0) {
            vector.addElement("Audio");
        }
        if ((n & 0x400000) > 0) {
            vector.addElement("Telephony");
        }
        if ((n & 0x800000) > 0) {
            vector.addElement("Information");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isContainsUUID(ServiceRecord serviceRecord, UUID uUID) {
        int[] nArray = serviceRecord.getAttributeIDs();
        for (int i = 0; i < nArray.length; ++i) {
            DataElement dataElement = serviceRecord.getAttributeValue(nArray[i]);
            if (!Util.isContainsUUID(dataElement, uUID)) continue;
            return true;
        }
        return false;
    }

    private static boolean isContainsUUID(DataElement dataElement, UUID uUID) {
        int n = dataElement.getDataType();
        if (n == 24) {
            if (dataElement.getValue().equals(uUID)) {
                return true;
            }
        } else if (n == 56 || n == 48) {
            Enumeration enumeration = (Enumeration)dataElement.getValue();
            while (enumeration.hasMoreElements()) {
                DataElement dataElement2 = (DataElement)enumeration.nextElement();
                if (!Util.isContainsUUID(dataElement2, uUID)) continue;
                return true;
            }
        }
        return false;
    }
}

